<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DonationRequest extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;
    protected $fillable = array('client_id', 'blood_type_id', 'city_id', 'patient_name', 'patient_phone', 'patient_age', 'hospital_name', 'hospital_address', 'blood_cysts', 'details', 'latitude', 'longitude');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function bloodType()
    {
        return $this->belongsTo('App\Models\BloodType');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification');
    }

}